-- 1. Unpaid purchases (no payment recorded)


SELECT p.PurchaseID, p.PurchaseDateTime, c.FirstName, c.LastName, s.StoreName
FROM Purchases p
JOIN Customers c ON c.CustomerID = p.CustomerID
JOIN Stores s ON s.StoreID = p.StoreID
LEFT JOIN Payments pay ON pay.PurchaseID = p.PurchaseID
WHERE pay.PurchaseID IS NULL
ORDER BY p.PurchaseDateTime DESC;


-- 2. Customer’s last 5 purchases with item count and paid amount


SELECT p.PurchaseID,
       p.PurchaseDateTime,
       COUNT(pi.ProductID) AS item_lines,
       COALESCE(pay.Amount, 0)::DECIMAL(10,2) AS paid_amount
FROM Purchases p
LEFT JOIN Purchase_Items pi ON pi.PurchaseID = p.PurchaseID
LEFT JOIN Payments pay ON pay.PurchaseID = p.PurchaseID
WHERE p.CustomerID = $1
GROUP BY p.PurchaseID, p.PurchaseDateTime, pay.Amount
ORDER BY p.PurchaseDateTime DESC
LIMIT 5;
-- $1 = customer_id


-- 3. Revenue & transaction count per store in a date range


SELECT s.StoreID, s.StoreName,
       COUNT(DISTINCT p.PurchaseID) AS transactions,
       COALESCE(SUM(pay.Amount), 0)::DECIMAL(10,2) AS revenue
FROM Stores s
LEFT JOIN Purchases p ON p.StoreID = s.StoreID
LEFT JOIN Payments pay ON pay.PurchaseID = p.PurchaseID
WHERE p.PurchaseDateTime >= $1 AND p.PurchaseDateTime < $2
GROUP BY s.StoreID, s.StoreName
ORDER BY revenue DESC;
-- $1 = start_ts, $2 = end_ts


-- 4. Top 5 products by revenue in the last N days


SELECT pr.ProductID, pr.ProductName,
       SUM(pi.Quantity) AS units_sold,
       SUM(pi.Quantity * pr.Price)::DECIMAL(10,2) AS gross_revenue
FROM Purchases pu
JOIN Purchase_Items pi ON pi.PurchaseID = pu.PurchaseID
JOIN Products pr ON pr.ProductID = pi.ProductID
WHERE pu.PurchaseDateTime >= $1
GROUP BY pr.ProductID, pr.ProductName
ORDER BY gross_revenue DESC
LIMIT 5;
-- $1 = (CURRENT_TIMESTAMP - INTERVAL 'N days') or a bound you pass in


-- 5. Suppliers for a given product (comma-separated)


SELECT pr.ProductID, pr.ProductName,
       STRING_AGG(s.SupplierName, ', ' ORDER BY s.SupplierName) AS suppliers
FROM Products pr
LEFT JOIN Product_Suppliers ps ON ps.ProductID = pr.ProductID
LEFT JOIN Suppliers s ON s.SupplierID = ps.SupplierID
WHERE pr.ProductID = $1
GROUP BY pr.ProductID, pr.ProductName;
-- $1 = product_id

